import { ConsumerConfig, Msg, Nanos } from "./types";
import { NatsError } from "./error";
export declare function validateDurableName(name?: string): void;
export declare function validateStreamName(name?: string): void;
export declare function validateName(context: string, name?: string): void;
export declare function defaultConsumer(name: string, opts?: Partial<ConsumerConfig>): ConsumerConfig;
export declare function nanos(millis: number): Nanos;
export declare function millis(ns: Nanos): number;
export declare function isFlowControlMsg(msg: Msg): boolean;
export declare function isHeartbeatMsg(msg: Msg): boolean;
export declare function checkJsError(msg: Msg): NatsError | null;
export declare function checkJsErrorCode(code: number, description?: string): NatsError | null;
