import { ConsumerConfig, JetStreamClient, JetStreamManager, JsMsg, KV, KvCodec, KvCodecs, KvEntry, KvOptions, KvPutOptions, KvRemove, KvStatus, PurgeOpts, PurgeResponse, StoredMsg } from "./types";
import { QueuedIterator } from "./queued_iterator";
import { MsgHdrs } from "./headers";
export declare function Base64KeyCodec(): KvCodec<string>;
export declare function NoopKvCodecs(): KvCodecs;
export declare function defaultBucketOpts(): Partial<KvOptions>;
export declare const kvOperationHdr = "KV-Operation";
export declare function validateKey(k: string): void;
export declare function validateSearchKey(k: string): void;
export declare function hasWildcards(k: string): boolean;
export declare function validateBucket(name: string): void;
export declare class Bucket implements KV, KvRemove {
    jsm: JetStreamManager;
    js: JetStreamClient;
    stream: string;
    bucket: string;
    codec: KvCodecs;
    _prefixLen: number;
    subjPrefix: string;
    constructor(bucket: string, jsm: JetStreamManager, js: JetStreamClient);
    static create(js: JetStreamClient, name: string, opts?: Partial<KvOptions>): Promise<KV>;
    init(opts?: Partial<KvOptions>): Promise<void>;
    bucketName(): string;
    subjectForBucket(): string;
    subjectForKey(k: string): string;
    fullKeyName(k: string): string;
    get prefixLen(): number;
    encodeKey(key: string): string;
    decodeKey(ekey: string): string;
    validateKey: typeof validateKey;
    validateSearchKey: typeof validateSearchKey;
    hasWildcards: typeof hasWildcards;
    close(): Promise<void>;
    dataLen(data: Uint8Array, h?: MsgHdrs): number;
    smToEntry(key: string, sm: StoredMsg): KvEntry;
    jmToEntry(k: string, jm: JsMsg): KvEntry;
    create(k: string, data: Uint8Array): Promise<number>;
    update(k: string, data: Uint8Array, version: number): Promise<number>;
    put(k: string, data: Uint8Array, opts?: Partial<KvPutOptions>): Promise<number>;
    get(k: string): Promise<KvEntry | null>;
    purge(k: string): Promise<void>;
    delete(k: string): Promise<void>;
    _deleteOrPurge(k: string, op: "DEL" | "PURGE"): Promise<void>;
    _doDeleteOrPurge(k: string, op: "DEL" | "PURGE"): Promise<void>;
    _buildCC(k: string, history?: boolean, opts?: Partial<ConsumerConfig>): Partial<ConsumerConfig>;
    remove(k: string): Promise<void>;
    history(opts?: {
        key?: string;
        headers_only?: boolean;
    }): Promise<QueuedIterator<KvEntry>>;
    watch(opts?: {
        key?: string;
        headers_only?: boolean;
    }): Promise<QueuedIterator<KvEntry>>;
    keys(k?: string): Promise<QueuedIterator<string>>;
    purgeBucket(opts?: PurgeOpts): Promise<PurgeResponse>;
    destroy(): Promise<boolean>;
    status(): Promise<KvStatus>;
}
