"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.MuxSubscription = void 0;
const error_1 = require("./error");
const protocol_1 = require("./protocol");
const msg_1 = require("./msg");
class MuxSubscription {
    constructor() {
        this.reqs = new Map();
    }
    size() {
        return this.reqs.size;
    }
    init(prefix) {
        this.baseInbox = `${(0, protocol_1.createInbox)(prefix)}.`;
        return this.baseInbox;
    }
    add(r) {
        if (!isNaN(r.received)) {
            r.received = 0;
        }
        this.reqs.set(r.token, r);
    }
    get(token) {
        return this.reqs.get(token);
    }
    cancel(r) {
        this.reqs.delete(r.token);
    }
    getToken(m) {
        const s = m.subject || "";
        if (s.indexOf(this.baseInbox) === 0) {
            return s.substring(this.baseInbox.length);
        }
        return null;
    }
    dispatcher() {
        return (err, m) => {
            const token = this.getToken(m);
            if (token) {
                const r = this.get(token);
                if (r) {
                    if (err === null && m.headers) {
                        err = (0, msg_1.isRequestError)(m);
                    }
                    r.resolver(err, m);
                }
            }
        };
    }
    close() {
        const err = error_1.NatsError.errorForCode(error_1.ErrorCode.Timeout);
        this.reqs.forEach((req) => {
            req.resolver(err, {});
        });
    }
}
exports.MuxSubscription = MuxSubscription;
//# sourceMappingURL=muxsubscription.js.map