import { ConnectionOptions, PublishOptions, Server, ServerInfo, Status, Subscription } from "./types";
import { Transport } from "./transport";
import { NatsError } from "./error";
import { Deferred } from "./util";
import { DataBuffer } from "./databuffer";
import { ServerImpl, Servers } from "./servers";
import { Dispatcher, QueuedIterator } from "./queued_iterator";
import type { MsgHdrs } from "./headers";
import { SubscriptionImpl } from "./subscription";
import { Subscriptions } from "./subscriptions";
import { MuxSubscription } from "./muxsubscription";
import type { Request } from "./request";
import { Heartbeat } from "./heartbeats";
import { MsgArg, Parser, ParserEvent } from "./parser";
export declare const INFO: RegExp;
export declare function createInbox(prefix?: string): string;
export declare class Connect {
    echo?: boolean;
    no_responders?: boolean;
    protocol: number;
    verbose?: boolean;
    pedantic?: boolean;
    jwt?: string;
    nkey?: string;
    sig?: string;
    user?: string;
    pass?: string;
    auth_token?: string;
    tls_required?: boolean;
    name?: string;
    lang: string;
    version: string;
    headers?: boolean;
    constructor(transport: {
        version: string;
        lang: string;
    }, opts: ConnectionOptions, nonce?: string);
}
export interface Publisher {
    publish(subject: string, data: Uint8Array, options?: {
        reply?: string;
        headers?: MsgHdrs;
    }): void;
}
export declare class ProtocolHandler implements Dispatcher<ParserEvent> {
    connected: boolean;
    connectedOnce: boolean;
    infoReceived: boolean;
    info?: ServerInfo;
    muxSubscriptions: MuxSubscription;
    options: ConnectionOptions;
    outbound: DataBuffer;
    pongs: Array<Deferred<void>>;
    subscriptions: Subscriptions;
    transport: Transport;
    noMorePublishing: boolean;
    connectError?: (err?: Error) => void;
    publisher: Publisher;
    _closed: boolean;
    closed: Deferred<Error | void>;
    listeners: QueuedIterator<Status>[];
    heartbeats: Heartbeat;
    parser: Parser;
    outMsgs: number;
    inMsgs: number;
    outBytes: number;
    inBytes: number;
    pendingLimit: number;
    lastError?: NatsError;
    abortReconnect: boolean;
    servers: Servers;
    server: ServerImpl;
    constructor(options: ConnectionOptions, publisher: Publisher);
    resetOutbound(): void;
    dispatchStatus(status: Status): void;
    status(): AsyncIterable<Status>;
    private prepare;
    disconnect(): void;
    disconnected(_err?: Error): Promise<void>;
    dial(srv: Server): Promise<void>;
    _doDial(srv: Server): Promise<void>;
    dialLoop(): Promise<void>;
    static connect(options: ConnectionOptions, publisher: Publisher): Promise<ProtocolHandler>;
    static toError(s: string): NatsError;
    processMsg(msg: MsgArg, data: Uint8Array): void;
    processError(m: Uint8Array): Promise<void>;
    handleError(err: NatsError): Promise<void>;
    handleAuthError(err: NatsError): void;
    processPing(): void;
    processPong(): void;
    processInfo(m: Uint8Array): void;
    push(e: ParserEvent): void;
    sendCommand(cmd: (string | Uint8Array), ...payloads: Uint8Array[]): void;
    publish(subject: string, data: Uint8Array, options?: PublishOptions): void;
    request(r: Request): Request;
    subscribe(s: SubscriptionImpl): Subscription;
    _sub(s: SubscriptionImpl): void;
    _subunsub(s: SubscriptionImpl): SubscriptionImpl;
    unsubscribe(s: SubscriptionImpl, max?: number): void;
    unsub(s: SubscriptionImpl, max?: number): void;
    resub(s: SubscriptionImpl, subject: string): void;
    flush(p?: Deferred<void>): Promise<void>;
    sendSubscriptions(): void;
    private _close;
    close(): Promise<void>;
    isClosed(): boolean;
    drain(): Promise<void>;
    private flushPending;
    private initMux;
    private selectServer;
    getServer(): ServerImpl | undefined;
}
