"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Request = void 0;
/*
 * Copyright 2020-2021 The NATS Authors
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
const util_1 = require("./util");
const error_1 = require("./error");
const nuid_1 = require("./nuid");
class Request {
    constructor(mux, opts = { timeout: 1000 }) {
        this.mux = mux;
        this.received = 0;
        this.deferred = (0, util_1.deferred)();
        this.token = nuid_1.nuid.next();
        (0, util_1.extend)(this, opts);
        this.timer = (0, util_1.timeout)(opts.timeout);
        this.ctx = new Error();
    }
    resolver(err, msg) {
        if (this.timer) {
            this.timer.cancel();
        }
        if (err) {
            err.stack += `\n\n${this.ctx.stack}`;
            this.deferred.reject(err);
        }
        else {
            this.deferred.resolve(msg);
        }
        this.cancel();
    }
    cancel(err) {
        if (this.timer) {
            this.timer.cancel();
        }
        this.mux.cancel(this);
        this.deferred.reject(err ? err : error_1.NatsError.errorForCode(error_1.ErrorCode.Cancelled));
    }
}
exports.Request = Request;
//# sourceMappingURL=request.js.map