"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.JsHeaders = exports.ReplayPolicy = exports.AckPolicy = exports.DeliverPolicy = exports.StorageType = exports.DiscardPolicy = exports.RetentionPolicy = exports.AdvisoryKind = exports.DEFAULT_MAX_PING_OUT = exports.DEFAULT_PING_INTERVAL = exports.DEFAULT_JITTER_TLS = exports.DEFAULT_JITTER = exports.DEFAULT_MAX_RECONNECT_ATTEMPTS = exports.DEFAULT_RECONNECT_TIME_WAIT = exports.DEFAULT_HOST = exports.DEFAULT_PORT = exports.DebugEvents = exports.Events = exports.Empty = void 0;
exports.Empty = new Uint8Array(0);
var Events;
(function (Events) {
    Events["Disconnect"] = "disconnect";
    Events["Reconnect"] = "reconnect";
    Events["Update"] = "update";
    Events["LDM"] = "ldm";
    Events["Error"] = "error";
})(Events = exports.Events || (exports.Events = {}));
var DebugEvents;
(function (DebugEvents) {
    DebugEvents["Reconnecting"] = "reconnecting";
    DebugEvents["PingTimer"] = "pingTimer";
    DebugEvents["StaleConnection"] = "staleConnection";
})(DebugEvents = exports.DebugEvents || (exports.DebugEvents = {}));
exports.DEFAULT_PORT = 4222;
exports.DEFAULT_HOST = "127.0.0.1";
// DISCONNECT Parameters, 2 sec wait, 10 tries
exports.DEFAULT_RECONNECT_TIME_WAIT = 2 * 1000;
exports.DEFAULT_MAX_RECONNECT_ATTEMPTS = 10;
exports.DEFAULT_JITTER = 100;
exports.DEFAULT_JITTER_TLS = 1000;
// Ping interval
exports.DEFAULT_PING_INTERVAL = 2 * 60 * 1000; // 2 minutes
exports.DEFAULT_MAX_PING_OUT = 2;
var AdvisoryKind;
(function (AdvisoryKind) {
    AdvisoryKind["API"] = "api_audit";
    AdvisoryKind["StreamAction"] = "stream_action";
    AdvisoryKind["ConsumerAction"] = "consumer_action";
    AdvisoryKind["SnapshotCreate"] = "snapshot_create";
    AdvisoryKind["SnapshotComplete"] = "snapshot_complete";
    AdvisoryKind["RestoreCreate"] = "restore_create";
    AdvisoryKind["RestoreComplete"] = "restore_complete";
    AdvisoryKind["MaxDeliver"] = "max_deliver";
    AdvisoryKind["Terminated"] = "terminated";
    AdvisoryKind["Ack"] = "consumer_ack";
    AdvisoryKind["StreamLeaderElected"] = "stream_leader_elected";
    AdvisoryKind["StreamQuorumLost"] = "stream_quorum_lost";
    AdvisoryKind["ConsumerLeaderElected"] = "consumer_leader_elected";
    AdvisoryKind["ConsumerQuorumLost"] = "consumer_quorum_lost";
})(AdvisoryKind = exports.AdvisoryKind || (exports.AdvisoryKind = {}));
var RetentionPolicy;
(function (RetentionPolicy) {
    RetentionPolicy["Limits"] = "limits";
    RetentionPolicy["Interest"] = "interest";
    RetentionPolicy["Workqueue"] = "workqueue";
})(RetentionPolicy = exports.RetentionPolicy || (exports.RetentionPolicy = {}));
var DiscardPolicy;
(function (DiscardPolicy) {
    DiscardPolicy["Old"] = "old";
    DiscardPolicy["New"] = "new";
})(DiscardPolicy = exports.DiscardPolicy || (exports.DiscardPolicy = {}));
var StorageType;
(function (StorageType) {
    StorageType["File"] = "file";
    StorageType["Memory"] = "memory";
})(StorageType = exports.StorageType || (exports.StorageType = {}));
var DeliverPolicy;
(function (DeliverPolicy) {
    DeliverPolicy["All"] = "all";
    DeliverPolicy["Last"] = "last";
    DeliverPolicy["New"] = "new";
    DeliverPolicy["StartSequence"] = "by_start_sequence";
    DeliverPolicy["StartTime"] = "by_start_time";
    DeliverPolicy["LastPerSubject"] = "last_per_subject";
})(DeliverPolicy = exports.DeliverPolicy || (exports.DeliverPolicy = {}));
var AckPolicy;
(function (AckPolicy) {
    AckPolicy["None"] = "none";
    AckPolicy["All"] = "all";
    AckPolicy["Explicit"] = "explicit";
    AckPolicy["NotSet"] = "";
})(AckPolicy = exports.AckPolicy || (exports.AckPolicy = {}));
var ReplayPolicy;
(function (ReplayPolicy) {
    ReplayPolicy["Instant"] = "instant";
    ReplayPolicy["Original"] = "original";
})(ReplayPolicy = exports.ReplayPolicy || (exports.ReplayPolicy = {}));
var JsHeaders;
(function (JsHeaders) {
    // set if message coming from a stream source format is `stream seq`
    JsHeaders["StreamSourceHdr"] = "Nats-Stream-Source";
    // set for heartbeat messages
    JsHeaders["LastConsumerSeqHdr"] = "Nats-Last-Consumer";
    // set for heartbeat messages
    JsHeaders["LastStreamSeqHdr"] = "Nats-Last-Stream";
    // set for heartbeat messages if stalled
    JsHeaders["ConsumerStalledHdr"] = "Nats-Consumer-Stalled";
    // set for headers_only consumers indicates number
    JsHeaders["MessageSizeHdr"] = "Nats-Msg-Size";
    // rollup header
    JsHeaders["RollupHdr"] = "Nats-Rollup";
    // value for rollup header when rolling up a subject
    JsHeaders["RollupValueSubject"] = "sub";
    // value for rollup header when rolling up all subjects
    JsHeaders["RollupValueAll"] = "all";
})(JsHeaders = exports.JsHeaders || (exports.JsHeaders = {}));
//# sourceMappingURL=types.js.map