import { QueuedIterator } from "./queued_iterator";
export declare const CR_LF = "\r\n";
export declare const CR_LF_LEN: number;
export declare const CRLF: Uint8Array;
export declare const CR: number;
export declare const LF: number;
export declare function isUint8Array(a: unknown): boolean;
export declare function protoLen(ba: Uint8Array): number;
export declare function extractProtocolMessage(a: Uint8Array): string;
export declare function extend(a: any, ...b: any[]): any;
export interface Pending {
    pending: number;
    write: (c: number) => void;
    wrote: (c: number) => void;
    err: (err: Error) => void;
    close: () => void;
    promise: () => Promise<any>;
    resolved: boolean;
    done: boolean;
}
export declare function render(frame: Uint8Array): string;
export interface Timeout<T> extends Promise<T> {
    cancel: () => void;
}
export declare function timeout<T>(ms: number): Timeout<T>;
export declare function delay(ms?: number): Promise<void>;
export interface Deferred<T> extends Promise<T> {
    resolve: (value?: T | PromiseLike<T>) => void;
    reject: (reason?: any) => void;
}
export declare function deferred<T>(): Deferred<T>;
export declare function shuffle<T>(a: T[]): T[];
export declare function collect<T>(iter: QueuedIterator<T>): Promise<T[]>;
export declare class Perf {
    timers: Map<string, number>;
    measures: Map<string, number>;
    constructor();
    mark(key: string): void;
    measure(key: string, startKey: string, endKey: string): void;
    getEntries(): {
        name: string;
        duration: number;
    }[];
}
