"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __asyncValues = (this && this.__asyncValues) || function (o) {
    if (!Symbol.asyncIterator) throw new TypeError("Symbol.asyncIterator is not defined.");
    var m = o[Symbol.asyncIterator], i;
    return m ? m.call(o) : (o = typeof __values === "function" ? __values(o) : o[Symbol.iterator](), i = {}, verb("next"), verb("throw"), verb("return"), i[Symbol.asyncIterator] = function () { return this; }, i);
    function verb(n) { i[n] = o[n] && function (v) { return new Promise(function (resolve, reject) { v = o[n](v), settle(resolve, reject, v.done, v.value); }); }; }
    function settle(resolve, reject, d, v) { Promise.resolve(v).then(function(v) { resolve({ value: v, done: d }); }, reject); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.Perf = exports.collect = exports.shuffle = exports.deferred = exports.delay = exports.timeout = exports.render = exports.extend = exports.extractProtocolMessage = exports.protoLen = exports.isUint8Array = exports.LF = exports.CR = exports.CRLF = exports.CR_LF_LEN = exports.CR_LF = void 0;
/*
 * Copyright 2018-2021 The NATS Authors
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// deno-lint-ignore-file no-explicit-any
const databuffer_1 = require("./databuffer");
const error_1 = require("./error");
const encoders_1 = require("./encoders");
exports.CR_LF = "\r\n";
exports.CR_LF_LEN = exports.CR_LF.length;
exports.CRLF = databuffer_1.DataBuffer.fromAscii(exports.CR_LF);
exports.CR = new Uint8Array(exports.CRLF)[0]; // 13
exports.LF = new Uint8Array(exports.CRLF)[1]; // 10
function isUint8Array(a) {
    return a instanceof Uint8Array;
}
exports.isUint8Array = isUint8Array;
function protoLen(ba) {
    for (let i = 0; i < ba.length; i++) {
        const n = i + 1;
        if (ba.byteLength > n && ba[i] === exports.CR && ba[n] === exports.LF) {
            return n + 1;
        }
    }
    return 0;
}
exports.protoLen = protoLen;
function extractProtocolMessage(a) {
    // protocol messages are ascii, so Uint8Array
    const len = protoLen(a);
    if (len > 0) {
        const ba = new Uint8Array(a);
        const out = ba.slice(0, len);
        return encoders_1.TD.decode(out);
    }
    return "";
}
exports.extractProtocolMessage = extractProtocolMessage;
function extend(a, ...b) {
    for (let i = 0; i < b.length; i++) {
        const o = b[i];
        Object.keys(o).forEach(function (k) {
            a[k] = o[k];
        });
    }
    return a;
}
exports.extend = extend;
function render(frame) {
    const cr = "␍";
    const lf = "␊";
    return encoders_1.TD.decode(frame)
        .replace(/\n/g, lf)
        .replace(/\r/g, cr);
}
exports.render = render;
function timeout(ms) {
    // by generating the stack here to help identify what timed out
    const err = error_1.NatsError.errorForCode(error_1.ErrorCode.Timeout);
    let methods;
    let timer;
    const p = new Promise((_resolve, reject) => {
        const cancel = () => {
            if (timer) {
                clearTimeout(timer);
            }
        };
        methods = { cancel };
        // @ts-ignore: node is not a number
        timer = setTimeout(() => {
            reject(err);
        }, ms);
    });
    // noinspection JSUnusedAssignment
    return Object.assign(p, methods);
}
exports.timeout = timeout;
function delay(ms = 0) {
    return new Promise((resolve) => {
        setTimeout(() => {
            resolve();
        }, ms);
    });
}
exports.delay = delay;
function deferred() {
    let methods = {};
    const p = new Promise((resolve, reject) => {
        methods = { resolve, reject };
    });
    return Object.assign(p, methods);
}
exports.deferred = deferred;
function shuffle(a) {
    for (let i = a.length - 1; i > 0; i--) {
        const j = Math.floor(Math.random() * (i + 1));
        [a[i], a[j]] = [a[j], a[i]];
    }
    return a;
}
exports.shuffle = shuffle;
function collect(iter) {
    var iter_1, iter_1_1;
    var e_1, _a;
    return __awaiter(this, void 0, void 0, function* () {
        const buf = [];
        try {
            for (iter_1 = __asyncValues(iter); iter_1_1 = yield iter_1.next(), !iter_1_1.done;) {
                const v = iter_1_1.value;
                buf.push(v);
            }
        }
        catch (e_1_1) { e_1 = { error: e_1_1 }; }
        finally {
            try {
                if (iter_1_1 && !iter_1_1.done && (_a = iter_1.return)) yield _a.call(iter_1);
            }
            finally { if (e_1) throw e_1.error; }
        }
        return buf;
    });
}
exports.collect = collect;
class Perf {
    constructor() {
        this.timers = new Map();
        this.measures = new Map();
    }
    mark(key) {
        this.timers.set(key, Date.now());
    }
    measure(key, startKey, endKey) {
        const s = this.timers.get(startKey);
        if (s === undefined) {
            throw new Error(`${startKey} is not defined`);
        }
        const e = this.timers.get(endKey);
        if (e === undefined) {
            throw new Error(`${endKey} is not defined`);
        }
        this.measures.set(key, e - s);
    }
    getEntries() {
        const values = [];
        this.measures.forEach((v, k) => {
            values.push({ name: k, duration: v });
        });
        return values;
    }
}
exports.Perf = Perf;
//# sourceMappingURL=util.js.map